@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ApmPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties of an APM
 * @property properties Non-sensitive properties for the APM
 * @property secrets Sensitive properties for the APM
 * @property type APM Type
 */
public data class ApmPropertiesArgs(
    public val properties: Output<Map<String, String>>? = null,
    public val secrets: Output<Map<String, String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ApmPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ApmPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ApmPropertiesArgs.builder()
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .secrets(secrets?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApmPropertiesArgs].
 */
@PulumiTagMarker
public class ApmPropertiesArgsBuilder internal constructor() {
    private var properties: Output<Map<String, String>>? = null

    private var secrets: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Non-sensitive properties for the APM
     */
    @JvmName("rwiwgpwirhmhktmk")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Sensitive properties for the APM
     */
    @JvmName("gtqmvhowumvccnyr")
    public suspend fun secrets(`value`: Output<Map<String, String>>) {
        this.secrets = value
    }

    /**
     * @param value APM Type
     */
    @JvmName("ynxkdcpssrlwcnyt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Non-sensitive properties for the APM
     */
    @JvmName("xumojqcdsoyuwkoj")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Non-sensitive properties for the APM
     */
    @JvmName("rtwcxlqhkygmvsav")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Sensitive properties for the APM
     */
    @JvmName("qnjopqtnlodhduld")
    public suspend fun secrets(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param values Sensitive properties for the APM
     */
    @JvmName("vytlqhevvpoyetsl")
    public fun secrets(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value APM Type
     */
    @JvmName("auuotshqhnmywfqy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApmPropertiesArgs = ApmPropertiesArgs(
        properties = properties,
        secrets = secrets,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
