@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuilderPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * KPack Builder properties payload
 * @property buildpackGroups Builder buildpack groups.
 * @property stack Builder cluster stack property.
 */
public data class BuilderPropertiesArgs(
    public val buildpackGroups: Output<List<BuildpacksGroupPropertiesArgs>>? = null,
    public val stack: Output<StackPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuilderPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuilderPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuilderPropertiesArgs.builder()
            .buildpackGroups(
                buildpackGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stack(stack?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BuilderPropertiesArgs].
 */
@PulumiTagMarker
public class BuilderPropertiesArgsBuilder internal constructor() {
    private var buildpackGroups: Output<List<BuildpacksGroupPropertiesArgs>>? = null

    private var stack: Output<StackPropertiesArgs>? = null

    /**
     * @param value Builder buildpack groups.
     */
    @JvmName("wseoiuvikgodcoox")
    public suspend fun buildpackGroups(`value`: Output<List<BuildpacksGroupPropertiesArgs>>) {
        this.buildpackGroups = value
    }

    @JvmName("abvvgmkvdchnrpjy")
    public suspend fun buildpackGroups(vararg values: Output<BuildpacksGroupPropertiesArgs>) {
        this.buildpackGroups = Output.all(values.asList())
    }

    /**
     * @param values Builder buildpack groups.
     */
    @JvmName("lruilahuasjbrsie")
    public suspend fun buildpackGroups(values: List<Output<BuildpacksGroupPropertiesArgs>>) {
        this.buildpackGroups = Output.all(values)
    }

    /**
     * @param value Builder cluster stack property.
     */
    @JvmName("vpciwhejrfmfojut")
    public suspend fun stack(`value`: Output<StackPropertiesArgs>) {
        this.stack = value
    }

    /**
     * @param value Builder buildpack groups.
     */
    @JvmName("usobeyerupfglvis")
    public suspend fun buildpackGroups(`value`: List<BuildpacksGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildpackGroups = mapped
    }

    /**
     * @param argument Builder buildpack groups.
     */
    @JvmName("jigykfigvsrpixsp")
    public suspend fun buildpackGroups(argument: List<suspend BuildpacksGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BuildpacksGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildpackGroups = mapped
    }

    /**
     * @param argument Builder buildpack groups.
     */
    @JvmName("wiwletperdgnvnvl")
    public suspend fun buildpackGroups(vararg argument: suspend BuildpacksGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BuildpacksGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildpackGroups = mapped
    }

    /**
     * @param argument Builder buildpack groups.
     */
    @JvmName("bkbjftbqvyeabeoq")
    public suspend fun buildpackGroups(argument: suspend BuildpacksGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BuildpacksGroupPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.buildpackGroups = mapped
    }

    /**
     * @param values Builder buildpack groups.
     */
    @JvmName("jbxptmfihchubnbv")
    public suspend fun buildpackGroups(vararg values: BuildpacksGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buildpackGroups = mapped
    }

    /**
     * @param value Builder cluster stack property.
     */
    @JvmName("wmaqyqcxncapdgxi")
    public suspend fun stack(`value`: StackPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stack = mapped
    }

    /**
     * @param argument Builder cluster stack property.
     */
    @JvmName("wwxdwblkculltlfn")
    public suspend fun stack(argument: suspend StackPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StackPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stack = mapped
    }

    internal fun build(): BuilderPropertiesArgs = BuilderPropertiesArgs(
        buildpackGroups = buildpackGroups,
        stack = stack,
    )
}
