@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CertificateReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to the certificate
 * @property resourceId Resource Id of the certificate
 */
public data class CertificateReferenceArgs(
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CertificateReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.CertificateReferenceArgs =
        com.pulumi.azurenative.appplatform.inputs.CertificateReferenceArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateReferenceArgs].
 */
@PulumiTagMarker
public class CertificateReferenceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value Resource Id of the certificate
     */
    @JvmName("dvxrakpxoklhsvcv")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource Id of the certificate
     */
    @JvmName("pjdjkugkcupcuyvd")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): CertificateReferenceArgs = CertificateReferenceArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
