@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Property of git environment.
 * @property repositories Repositories of Application Configuration Service git property.
 */
public data class ConfigurationServiceGitPropertyArgs(
    public val repositories: Output<List<ConfigurationServiceGitRepositoryArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitPropertyArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitPropertyArgs.builder()
            .repositories(
                repositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationServiceGitPropertyArgs].
 */
@PulumiTagMarker
public class ConfigurationServiceGitPropertyArgsBuilder internal constructor() {
    private var repositories: Output<List<ConfigurationServiceGitRepositoryArgs>>? = null

    /**
     * @param value Repositories of Application Configuration Service git property.
     */
    @JvmName("aoqteylbvbxsmnkr")
    public suspend fun repositories(`value`: Output<List<ConfigurationServiceGitRepositoryArgs>>) {
        this.repositories = value
    }

    @JvmName("erlrupslnnxgglux")
    public suspend fun repositories(vararg values: Output<ConfigurationServiceGitRepositoryArgs>) {
        this.repositories = Output.all(values.asList())
    }

    /**
     * @param values Repositories of Application Configuration Service git property.
     */
    @JvmName("lluxmoyltyokokld")
    public suspend fun repositories(values: List<Output<ConfigurationServiceGitRepositoryArgs>>) {
        this.repositories = Output.all(values)
    }

    /**
     * @param value Repositories of Application Configuration Service git property.
     */
    @JvmName("raoejaotrpllakjk")
    public suspend fun repositories(`value`: List<ConfigurationServiceGitRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of Application Configuration Service git property.
     */
    @JvmName("rubrxiumedaeovsm")
    public suspend fun repositories(argument: List<suspend ConfigurationServiceGitRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationServiceGitRepositoryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of Application Configuration Service git property.
     */
    @JvmName("gsksbcaclamikyqw")
    public suspend fun repositories(vararg argument: suspend ConfigurationServiceGitRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationServiceGitRepositoryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of Application Configuration Service git property.
     */
    @JvmName("qgxifowebwbvqhjq")
    public suspend fun repositories(argument: suspend ConfigurationServiceGitRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConfigurationServiceGitRepositoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param values Repositories of Application Configuration Service git property.
     */
    @JvmName("dhxxxoecgqedqxwp")
    public suspend fun repositories(vararg values: ConfigurationServiceGitRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    internal fun build(): ConfigurationServiceGitPropertyArgs = ConfigurationServiceGitPropertyArgs(
        repositories = repositories,
    )
}
