@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitRepositoryArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.GitImplementation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Git repository property payload for Application Configuration Service
 * @property caCertResourceId Resource Id of CA certificate for https URL of Git repository.
 * @property gitImplementation Git libraries used to support various repository providers
 * @property hostKey Public sshKey of git repository.
 * @property hostKeyAlgorithm SshKey algorithm of git repository.
 * @property label Label of the repository
 * @property name Name of the repository
 * @property password Password of git repository basic auth.
 * @property patterns Collection of patterns of the repository
 * @property privateKey Private sshKey algorithm of git repository.
 * @property searchPaths Searching path of the repository
 * @property strictHostKeyChecking Strict host key checking or not.
 * @property uri URI of the repository
 * @property username Username of git repository basic auth.
 */
public data class ConfigurationServiceGitRepositoryArgs(
    public val caCertResourceId: Output<String>? = null,
    public val gitImplementation: Output<Either<String, GitImplementation>>? = null,
    public val hostKey: Output<String>? = null,
    public val hostKeyAlgorithm: Output<String>? = null,
    public val label: Output<String>,
    public val name: Output<String>,
    public val password: Output<String>? = null,
    public val patterns: Output<List<String>>,
    public val privateKey: Output<String>? = null,
    public val searchPaths: Output<List<String>>? = null,
    public val strictHostKeyChecking: Output<Boolean>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitRepositoryArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitRepositoryArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitRepositoryArgs.builder()
            .caCertResourceId(caCertResourceId?.applyValue({ args0 -> args0 }))
            .gitImplementation(
                gitImplementation?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .hostKey(hostKey?.applyValue({ args0 -> args0 }))
            .hostKeyAlgorithm(hostKeyAlgorithm?.applyValue({ args0 -> args0 }))
            .label(label.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .patterns(patterns.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .searchPaths(searchPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .strictHostKeyChecking(strictHostKeyChecking?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationServiceGitRepositoryArgs].
 */
@PulumiTagMarker
public class ConfigurationServiceGitRepositoryArgsBuilder internal constructor() {
    private var caCertResourceId: Output<String>? = null

    private var gitImplementation: Output<Either<String, GitImplementation>>? = null

    private var hostKey: Output<String>? = null

    private var hostKeyAlgorithm: Output<String>? = null

    private var label: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var patterns: Output<List<String>>? = null

    private var privateKey: Output<String>? = null

    private var searchPaths: Output<List<String>>? = null

    private var strictHostKeyChecking: Output<Boolean>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("edqfvrsoguyijnmc")
    public suspend fun caCertResourceId(`value`: Output<String>) {
        this.caCertResourceId = value
    }

    /**
     * @param value Git libraries used to support various repository providers
     */
    @JvmName("cejdprhvmdqalqqb")
    public suspend fun gitImplementation(`value`: Output<Either<String, GitImplementation>>) {
        this.gitImplementation = value
    }

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("omlwvqywnehxsrxe")
    public suspend fun hostKey(`value`: Output<String>) {
        this.hostKey = value
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("ajmrridbjlvceqmc")
    public suspend fun hostKeyAlgorithm(`value`: Output<String>) {
        this.hostKeyAlgorithm = value
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("sjwbfsbpaxxrwpts")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Name of the repository
     */
    @JvmName("idelsgrmscqhvxij")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("ragkpemvpgjnephq")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Collection of patterns of the repository
     */
    @JvmName("ohwwtuvxvqytnmcf")
    public suspend fun patterns(`value`: Output<List<String>>) {
        this.patterns = value
    }

    @JvmName("crhgvvawfdodjmqb")
    public suspend fun patterns(vararg values: Output<String>) {
        this.patterns = Output.all(values.asList())
    }

    /**
     * @param values Collection of patterns of the repository
     */
    @JvmName("mmigemepafmnkebs")
    public suspend fun patterns(values: List<Output<String>>) {
        this.patterns = Output.all(values)
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("wnqlntftlxihytxq")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("undsxisyevwsqmdv")
    public suspend fun searchPaths(`value`: Output<List<String>>) {
        this.searchPaths = value
    }

    @JvmName("yiyfiphqlrairjyd")
    public suspend fun searchPaths(vararg values: Output<String>) {
        this.searchPaths = Output.all(values.asList())
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("qhkuqbaplwtmqwcf")
    public suspend fun searchPaths(values: List<Output<String>>) {
        this.searchPaths = Output.all(values)
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("vmxiircohdivtkqm")
    public suspend fun strictHostKeyChecking(`value`: Output<Boolean>) {
        this.strictHostKeyChecking = value
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("ejbivmyfxgohtajv")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("hljjlhjaciuxqkio")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("xluxfrulkukbvthy")
    public suspend fun caCertResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertResourceId = mapped
    }

    /**
     * @param value Git libraries used to support various repository providers
     */
    @JvmName("tulrfsvxjwiioywd")
    public suspend fun gitImplementation(`value`: Either<String, GitImplementation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitImplementation = mapped
    }

    /**
     * @param value Git libraries used to support various repository providers
     */
    @JvmName("mogauiqjbajpjwhe")
    public fun gitImplementation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GitImplementation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitImplementation = mapped
    }

    /**
     * @param value Git libraries used to support various repository providers
     */
    @JvmName("gedghxajqkfneakt")
    public fun gitImplementation(`value`: GitImplementation) {
        val toBeMapped = Either.ofRight<String, GitImplementation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitImplementation = mapped
    }

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("rohktdrkhfgjfofu")
    public suspend fun hostKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKey = mapped
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("fkhktkwayjpifkkr")
    public suspend fun hostKeyAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKeyAlgorithm = mapped
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("jhnmkiiagdsyegjh")
    public suspend fun label(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Name of the repository
     */
    @JvmName("nribivahmqsjystn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("sdwbderluraiagct")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Collection of patterns of the repository
     */
    @JvmName("nsfjtyvrslgbcjgw")
    public suspend fun patterns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patterns = mapped
    }

    /**
     * @param values Collection of patterns of the repository
     */
    @JvmName("xvnvcynqvgukepna")
    public suspend fun patterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patterns = mapped
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("vxfempsfsoytkcev")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("urdpigqucseyrtnx")
    public suspend fun searchPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("fcwstudrngplfqot")
    public suspend fun searchPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("jupervkqinhrbrfn")
    public suspend fun strictHostKeyChecking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strictHostKeyChecking = mapped
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("raadtquckwwelqkj")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("vqydasbpwopvytdu")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ConfigurationServiceGitRepositoryArgs =
        ConfigurationServiceGitRepositoryArgs(
            caCertResourceId = caCertResourceId,
            gitImplementation = gitImplementation,
            hostKey = hostKey,
            hostKeyAlgorithm = hostKeyAlgorithm,
            label = label ?: throw PulumiNullFieldException("label"),
            name = name ?: throw PulumiNullFieldException("name"),
            password = password,
            patterns = patterns ?: throw PulumiNullFieldException("patterns"),
            privateKey = privateKey,
            searchPaths = searchPaths,
            strictHostKeyChecking = strictHostKeyChecking,
            uri = uri ?: throw PulumiNullFieldException("uri"),
            username = username,
        )
}
