@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CustomContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Custom container payload
 * @property args Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
 * @property command Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
 * @property containerImage Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
 * @property imageRegistryCredential Credential of the image registry
 * @property languageFramework Language framework of the container image uploaded. Supported values: "springboot", "", null.
 * @property server The name of the registry that contains the container image
 */
public data class CustomContainerArgs(
    public val args: Output<List<String>>? = null,
    public val command: Output<List<String>>? = null,
    public val containerImage: Output<String>? = null,
    public val imageRegistryCredential: Output<ImageRegistryCredentialArgs>? = null,
    public val languageFramework: Output<String>? = null,
    public val server: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CustomContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.CustomContainerArgs =
        com.pulumi.azurenative.appplatform.inputs.CustomContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerImage(containerImage?.applyValue({ args0 -> args0 }))
            .imageRegistryCredential(
                imageRegistryCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .languageFramework(languageFramework?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomContainerArgs].
 */
@PulumiTagMarker
public class CustomContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var command: Output<List<String>>? = null

    private var containerImage: Output<String>? = null

    private var imageRegistryCredential: Output<ImageRegistryCredentialArgs>? = null

    private var languageFramework: Output<String>? = null

    private var server: Output<String>? = null

    /**
     * @param value Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     */
    @JvmName("hkaojvwkexbekoro")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("nekfftdmjoefusvt")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     */
    @JvmName("msyokdpygghopnsk")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
     */
    @JvmName("cwsjtnjbkuphjvff")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("pkvarqmurdeqhiml")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
     */
    @JvmName("gxgruwtctjjubnri")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
     */
    @JvmName("mlrewlalnkbvekmq")
    public suspend fun containerImage(`value`: Output<String>) {
        this.containerImage = value
    }

    /**
     * @param value Credential of the image registry
     */
    @JvmName("pfpnsfwanfxjnepp")
    public suspend fun imageRegistryCredential(`value`: Output<ImageRegistryCredentialArgs>) {
        this.imageRegistryCredential = value
    }

    /**
     * @param value Language framework of the container image uploaded. Supported values: "springboot", "", null.
     */
    @JvmName("qdfmdonbshclvcpy")
    public suspend fun languageFramework(`value`: Output<String>) {
        this.languageFramework = value
    }

    /**
     * @param value The name of the registry that contains the container image
     */
    @JvmName("iumlrggjqhmmuylj")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     */
    @JvmName("wruvpvufymuxbsng")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
     */
    @JvmName("muqbnlaogkharjlt")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
     */
    @JvmName("imubmqxtouosbuwe")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
     */
    @JvmName("eilmcqduwgcldapw")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
     */
    @JvmName("dsgcgsfhjtcoualm")
    public suspend fun containerImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerImage = mapped
    }

    /**
     * @param value Credential of the image registry
     */
    @JvmName("mdrooubqbvikqoqc")
    public suspend fun imageRegistryCredential(`value`: ImageRegistryCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredential = mapped
    }

    /**
     * @param argument Credential of the image registry
     */
    @JvmName("wvevrxqonkxphlpc")
    public suspend fun imageRegistryCredential(argument: suspend ImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ImageRegistryCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageRegistryCredential = mapped
    }

    /**
     * @param value Language framework of the container image uploaded. Supported values: "springboot", "", null.
     */
    @JvmName("qcgvluubsyrkuuit")
    public suspend fun languageFramework(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageFramework = mapped
    }

    /**
     * @param value The name of the registry that contains the container image
     */
    @JvmName("mxfjxhgssnolfcbe")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    internal fun build(): CustomContainerArgs = CustomContainerArgs(
        args = args,
        command = command,
        containerImage = containerImage,
        imageRegistryCredential = imageRegistryCredential,
        languageFramework = languageFramework,
        server = server,
    )
}
