@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment settings payload
 * @property addonConfigs Collection of addons
 * @property apms Collection of ApmReferences
 * @property containerProbeSettings Container liveness and readiness probe settings
 * @property environmentVariables Collection of environment variables
 * @property livenessProbe Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property readinessProbe Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property resourceRequests The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
 * @property scale Scaling properties for the Azure Spring Apps App Instance.
 * @property startupProbe StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property terminationGracePeriodSeconds Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
 */
public data class DeploymentSettingsArgs(
    public val addonConfigs: Output<Map<String, Any>>? = null,
    public val apms: Output<List<ApmReferenceArgs>>? = null,
    public val containerProbeSettings: Output<ContainerProbeSettingsArgs>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val livenessProbe: Output<ProbeArgs>? = null,
    public val readinessProbe: Output<ProbeArgs>? = null,
    public val resourceRequests: Output<ResourceRequestsArgs>? = null,
    public val scale: Output<ScaleArgs>? = null,
    public val startupProbe: Output<ProbeArgs>? = null,
    public val terminationGracePeriodSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs.builder()
            .addonConfigs(
                addonConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .apms(apms?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .containerProbeSettings(
                containerProbeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .livenessProbe(livenessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readinessProbe(readinessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceRequests(resourceRequests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startupProbe(startupProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .terminationGracePeriodSeconds(
                terminationGracePeriodSeconds?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DeploymentSettingsArgs].
 */
@PulumiTagMarker
public class DeploymentSettingsArgsBuilder internal constructor() {
    private var addonConfigs: Output<Map<String, Any>>? = null

    private var apms: Output<List<ApmReferenceArgs>>? = null

    private var containerProbeSettings: Output<ContainerProbeSettingsArgs>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var livenessProbe: Output<ProbeArgs>? = null

    private var readinessProbe: Output<ProbeArgs>? = null

    private var resourceRequests: Output<ResourceRequestsArgs>? = null

    private var scale: Output<ScaleArgs>? = null

    private var startupProbe: Output<ProbeArgs>? = null

    private var terminationGracePeriodSeconds: Output<Int>? = null

    /**
     * @param value Collection of addons
     */
    @JvmName("llsvejdsafdwnjty")
    public suspend fun addonConfigs(`value`: Output<Map<String, Any>>) {
        this.addonConfigs = value
    }

    /**
     * @param value Collection of ApmReferences
     */
    @JvmName("xsrpegfqorcrlvws")
    public suspend fun apms(`value`: Output<List<ApmReferenceArgs>>) {
        this.apms = value
    }

    @JvmName("eacgckboqkcuxrwp")
    public suspend fun apms(vararg values: Output<ApmReferenceArgs>) {
        this.apms = Output.all(values.asList())
    }

    /**
     * @param values Collection of ApmReferences
     */
    @JvmName("kpvjhbhqvpwvyakq")
    public suspend fun apms(values: List<Output<ApmReferenceArgs>>) {
        this.apms = Output.all(values)
    }

    /**
     * @param value Container liveness and readiness probe settings
     */
    @JvmName("acxkrlbbqnvojdcl")
    public suspend fun containerProbeSettings(`value`: Output<ContainerProbeSettingsArgs>) {
        this.containerProbeSettings = value
    }

    /**
     * @param value Collection of environment variables
     */
    @JvmName("mwuahjogceiaummx")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("ajfqgkhrmkgxssqq")
    public suspend fun livenessProbe(`value`: Output<ProbeArgs>) {
        this.livenessProbe = value
    }

    /**
     * @param value Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("jlhlaefobhhkwgjh")
    public suspend fun readinessProbe(`value`: Output<ProbeArgs>) {
        this.readinessProbe = value
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
     */
    @JvmName("msmkqtkuqvegplkw")
    public suspend fun resourceRequests(`value`: Output<ResourceRequestsArgs>) {
        this.resourceRequests = value
    }

    /**
     * @param value Scaling properties for the Azure Spring Apps App Instance.
     */
    @JvmName("kbcyoftgfdegynwa")
    public suspend fun scale(`value`: Output<ScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("aaotrsorvexwynfd")
    public suspend fun startupProbe(`value`: Output<ProbeArgs>) {
        this.startupProbe = value
    }

    /**
     * @param value Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
     */
    @JvmName("newdroysxbpslouu")
    public suspend fun terminationGracePeriodSeconds(`value`: Output<Int>) {
        this.terminationGracePeriodSeconds = value
    }

    /**
     * @param value Collection of addons
     */
    @JvmName("tstoxfdlrhratjjs")
    public suspend fun addonConfigs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param values Collection of addons
     */
    @JvmName("alfogrqvanvmuarr")
    public fun addonConfigs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param value Collection of ApmReferences
     */
    @JvmName("orhjpcactgwhpsgo")
    public suspend fun apms(`value`: List<ApmReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apms = mapped
    }

    /**
     * @param argument Collection of ApmReferences
     */
    @JvmName("trlqifoafincvuqe")
    public suspend fun apms(argument: List<suspend ApmReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApmReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param argument Collection of ApmReferences
     */
    @JvmName("lpbwvftbqfwysmbf")
    public suspend fun apms(vararg argument: suspend ApmReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApmReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param argument Collection of ApmReferences
     */
    @JvmName("ywdcplaivjlwolgm")
    public suspend fun apms(argument: suspend ApmReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApmReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.apms = mapped
    }

    /**
     * @param values Collection of ApmReferences
     */
    @JvmName("gmhinvghleoogsmq")
    public suspend fun apms(vararg values: ApmReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apms = mapped
    }

    /**
     * @param value Container liveness and readiness probe settings
     */
    @JvmName("aedwjlmaxrjncvas")
    public suspend fun containerProbeSettings(`value`: ContainerProbeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerProbeSettings = mapped
    }

    /**
     * @param argument Container liveness and readiness probe settings
     */
    @JvmName("asmqqpclvyjpfpph")
    public suspend fun containerProbeSettings(argument: suspend ContainerProbeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerProbeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerProbeSettings = mapped
    }

    /**
     * @param value Collection of environment variables
     */
    @JvmName("cqunjjcctfsyahuo")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Collection of environment variables
     */
    @JvmName("rvwyctnngqdtqpgd")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("vbslcrkdvohnlqjk")
    public suspend fun livenessProbe(`value`: ProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbe = mapped
    }

    /**
     * @param argument Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("pjbicwgnxparhotf")
    public suspend fun livenessProbe(argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessProbe = mapped
    }

    /**
     * @param value Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("wfncvokftrqannsr")
    public suspend fun readinessProbe(`value`: ProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbe = mapped
    }

    /**
     * @param argument Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("pkmafyrujkeftafh")
    public suspend fun readinessProbe(argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessProbe = mapped
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
     */
    @JvmName("oduttgdneentbcma")
    public suspend fun resourceRequests(`value`: ResourceRequestsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequests = mapped
    }

    /**
     * @param argument The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
     */
    @JvmName("bhlsgnavytbesoeq")
    public suspend fun resourceRequests(argument: suspend ResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceRequests = mapped
    }

    /**
     * @param value Scaling properties for the Azure Spring Apps App Instance.
     */
    @JvmName("fnrxpqsofdfpdtkl")
    public suspend fun scale(`value`: ScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument Scaling properties for the Azure Spring Apps App Instance.
     */
    @JvmName("gaggdmanwpjjyngs")
    public suspend fun scale(argument: suspend ScaleArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    /**
     * @param value StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("xqybuprndmclyhhb")
    public suspend fun startupProbe(`value`: ProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startupProbe = mapped
    }

    /**
     * @param argument StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     */
    @JvmName("ddedpqveoutoeamh")
    public suspend fun startupProbe(argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.startupProbe = mapped
    }

    /**
     * @param value Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the App Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 90 seconds.
     */
    @JvmName("poouwohsspeldmoq")
    public suspend fun terminationGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationGracePeriodSeconds = mapped
    }

    internal fun build(): DeploymentSettingsArgs = DeploymentSettingsArgs(
        addonConfigs = addonConfigs,
        apms = apms,
        containerProbeSettings = containerProbeSettings,
        environmentVariables = environmentVariables,
        livenessProbe = livenessProbe,
        readinessProbe = readinessProbe,
        resourceRequests = resourceRequests,
        scale = scale,
        startupProbe = startupProbe,
        terminationGracePeriodSeconds = terminationGracePeriodSeconds,
    )
}
