@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.EnvVarArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Spring Apps components' environment variable.
 * @property name Environment variable name.
 * @property secretValue secret environment variable value.
 * @property value Non-secret environment variable value.
 */
public data class EnvVarArgs(
    public val name: Output<String>? = null,
    public val secretValue: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.EnvVarArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.EnvVarArgs =
        com.pulumi.azurenative.appplatform.inputs.EnvVarArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretValue(secretValue?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvVarArgs].
 */
@PulumiTagMarker
public class EnvVarArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretValue: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Environment variable name.
     */
    @JvmName("qmgxkdqgqskiwikt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value secret environment variable value.
     */
    @JvmName("yhmxhtofpypbchvs")
    public suspend fun secretValue(`value`: Output<String>) {
        this.secretValue = value
    }

    /**
     * @param value Non-secret environment variable value.
     */
    @JvmName("gapvyrkrbtrfyumc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Environment variable name.
     */
    @JvmName("lwlncitoqylswlmt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value secret environment variable value.
     */
    @JvmName("fufjkwchbjntsjke")
    public suspend fun secretValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretValue = mapped
    }

    /**
     * @param value Non-secret environment variable value.
     */
    @JvmName("jpjsffqcxdqkftns")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvVarArgs = EnvVarArgs(
        name = name,
        secretValue = secretValue,
        `value` = `value`,
    )
}
