@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The error code compose of code and message.
 * @property code The code of error.
 * @property message The message of error.
 */
public data class ErrorArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ErrorArgs =
        com.pulumi.azurenative.appplatform.inputs.ErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErrorArgs].
 */
@PulumiTagMarker
public class ErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value The code of error.
     */
    @JvmName("rdymdbieqeujjgnn")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The message of error.
     */
    @JvmName("jycodcpvnmrrooqm")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The code of error.
     */
    @JvmName("dqtueprjawykhriu")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The message of error.
     */
    @JvmName("rkswdifkasycnvlq")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): ErrorArgs = ErrorArgs(
        code = code,
        message = message,
    )
}
