@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ExecActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ExecAction describes a "run in container" action.
 * @property command Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'ExecAction'.
 */
public data class ExecActionArgs(
    public val command: Output<List<String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ExecActionArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ExecActionArgs =
        com.pulumi.azurenative.appplatform.inputs.ExecActionArgs.builder()
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExecActionArgs].
 */
@PulumiTagMarker
public class ExecActionArgsBuilder internal constructor() {
    private var command: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     */
    @JvmName("ygqxbpraayaucrnl")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("bopnycpxosjhmqow")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     */
    @JvmName("jwbiuripokevboqw")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'ExecAction'.
     */
    @JvmName("rahprmctigilwwwk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     */
    @JvmName("neikoadmrmydavbn")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     */
    @JvmName("qtdpymffnsmxirwq")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'ExecAction'.
     */
    @JvmName("mbqadygdxiwcqaln")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExecActionArgs = ExecActionArgs(
        command = command,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
