@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayCorsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cross-Origin Resource Sharing property
 * @property allowCredentials Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
 * @property allowedHeaders Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
 * @property allowedMethods Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
 * @property allowedOriginPatterns Allowed origin patterns to make cross-site requests.
 * @property allowedOrigins Allowed origins to make cross-site requests. The special value `*` allows all domains.
 * @property exposedHeaders HTTP response headers to expose for cross-site requests.
 * @property maxAge How long, in seconds, the response from a pre-flight request can be cached by clients.
 */
public data class GatewayCorsPropertiesArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>? = null,
    public val allowedOriginPatterns: Output<List<String>>? = null,
    public val allowedOrigins: Output<List<String>>? = null,
    public val exposedHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayCorsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayCorsPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayCorsPropertiesArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOriginPatterns(allowedOriginPatterns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposedHeaders(exposedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCorsPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayCorsPropertiesArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOriginPatterns: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposedHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
     */
    @JvmName("csijvsinwrlrslel")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
     */
    @JvmName("wqubbkedupatbhki")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("jcibjjkpqqslsdfi")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
     */
    @JvmName("wcrgncjwfmstgwet")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
     */
    @JvmName("veehgsvbmxfrkrcn")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("oarcqsccuatpwsvy")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
     */
    @JvmName("nosjtoxjhawwgffy")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Allowed origin patterns to make cross-site requests.
     */
    @JvmName("yriibkpadqxjsegx")
    public suspend fun allowedOriginPatterns(`value`: Output<List<String>>) {
        this.allowedOriginPatterns = value
    }

    @JvmName("tmpwvpocokfeqkrv")
    public suspend fun allowedOriginPatterns(vararg values: Output<String>) {
        this.allowedOriginPatterns = Output.all(values.asList())
    }

    /**
     * @param values Allowed origin patterns to make cross-site requests.
     */
    @JvmName("iartmkisvhtkmoro")
    public suspend fun allowedOriginPatterns(values: List<Output<String>>) {
        this.allowedOriginPatterns = Output.all(values)
    }

    /**
     * @param value Allowed origins to make cross-site requests. The special value `*` allows all domains.
     */
    @JvmName("mfyikwnchxursbju")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("duhyknkvqctfadsf")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Allowed origins to make cross-site requests. The special value `*` allows all domains.
     */
    @JvmName("jpgfssllafnhqcxv")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value HTTP response headers to expose for cross-site requests.
     */
    @JvmName("ybqxeriptfswrhaq")
    public suspend fun exposedHeaders(`value`: Output<List<String>>) {
        this.exposedHeaders = value
    }

    @JvmName("olcqfacbqmefybrp")
    public suspend fun exposedHeaders(vararg values: Output<String>) {
        this.exposedHeaders = Output.all(values.asList())
    }

    /**
     * @param values HTTP response headers to expose for cross-site requests.
     */
    @JvmName("yrrduhutjdssjbkr")
    public suspend fun exposedHeaders(values: List<Output<String>>) {
        this.exposedHeaders = Output.all(values)
    }

    /**
     * @param value How long, in seconds, the response from a pre-flight request can be cached by clients.
     */
    @JvmName("llpwjdyohonbholb")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`.
     */
    @JvmName("mdfansdauajqhejv")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
     */
    @JvmName("sesoxiejkydgavfv")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header.
     */
    @JvmName("rqnkmrodajdqhwql")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
     */
    @JvmName("mjtqwqukgwuxumwe")
    public suspend fun allowedMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default.
     */
    @JvmName("mvxhifrhexablusk")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Allowed origin patterns to make cross-site requests.
     */
    @JvmName("fkshhnoqtovrlyny")
    public suspend fun allowedOriginPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOriginPatterns = mapped
    }

    /**
     * @param values Allowed origin patterns to make cross-site requests.
     */
    @JvmName("xnbsurrogwkdeuaa")
    public suspend fun allowedOriginPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOriginPatterns = mapped
    }

    /**
     * @param value Allowed origins to make cross-site requests. The special value `*` allows all domains.
     */
    @JvmName("mrorvylchojbameg")
    public suspend fun allowedOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Allowed origins to make cross-site requests. The special value `*` allows all domains.
     */
    @JvmName("pcqcjiodscwfikit")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value HTTP response headers to expose for cross-site requests.
     */
    @JvmName("sjwmhlspajhxegau")
    public suspend fun exposedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param values HTTP response headers to expose for cross-site requests.
     */
    @JvmName("desglhpuboxkhudi")
    public suspend fun exposedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param value How long, in seconds, the response from a pre-flight request can be cached by clients.
     */
    @JvmName("rbxnrkwdbetprghd")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): GatewayCorsPropertiesArgs = GatewayCorsPropertiesArgs(
        allowCredentials = allowCredentials,
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods,
        allowedOriginPatterns = allowedOriginPatterns,
        allowedOrigins = allowedOrigins,
        exposedHeaders = exposedHeaders,
        maxAge = maxAge,
    )
}
