@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource request payload of Spring Cloud Gateway.
 * @property cpu Cpu allocated to each Spring Cloud Gateway instance.
 * @property memory Memory allocated to each Spring Cloud Gateway instance.
 */
public data class GatewayResourceRequestsArgs(
    public val cpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayResourceRequestsArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayResourceRequestsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayResourceRequestsArgs].
 */
@PulumiTagMarker
public class GatewayResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Cpu allocated to each Spring Cloud Gateway instance.
     */
    @JvmName("ekoaopwmkiivngci")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Memory allocated to each Spring Cloud Gateway instance.
     */
    @JvmName("mcibiinwmhbxunbl")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Cpu allocated to each Spring Cloud Gateway instance.
     */
    @JvmName("ubsgovdepvrpxvgq")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Memory allocated to each Spring Cloud Gateway instance.
     */
    @JvmName("qcemhqkgphsrimid")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): GatewayResourceRequestsArgs = GatewayResourceRequestsArgs(
        cpu = cpu,
        memory = memory,
    )
}
