@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetBuildServiceBuildPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property buildName The name of the build resource.
 * @property buildServiceName The name of the build service resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetBuildServiceBuildPlainArgs(
    public val buildName: String,
    public val buildServiceName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetBuildServiceBuildPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetBuildServiceBuildPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetBuildServiceBuildPlainArgs.builder()
            .buildName(buildName.let({ args0 -> args0 }))
            .buildServiceName(buildServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBuildServiceBuildPlainArgs].
 */
@PulumiTagMarker
public class GetBuildServiceBuildPlainArgsBuilder internal constructor() {
    private var buildName: String? = null

    private var buildServiceName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the build resource.
     */
    @JvmName("wpcjbyuvnchewqvt")
    public suspend fun buildName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildName = mapped
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("jhoubpbrogchjinw")
    public suspend fun buildServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildServiceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rrfloiunmhuqaagn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("bwdfyqrcttbjnvwm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetBuildServiceBuildPlainArgs = GetBuildServiceBuildPlainArgs(
        buildName = buildName ?: throw PulumiNullFieldException("buildName"),
        buildServiceName = buildServiceName ?: throw PulumiNullFieldException("buildServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
