@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetContainerRegistryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerRegistryName The name of the container registry.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetContainerRegistryPlainArgs(
    public val containerRegistryName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetContainerRegistryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetContainerRegistryPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetContainerRegistryPlainArgs.builder()
            .containerRegistryName(containerRegistryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerRegistryPlainArgs].
 */
@PulumiTagMarker
public class GetContainerRegistryPlainArgsBuilder internal constructor() {
    private var containerRegistryName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("tdmvcvpvlauyrjsf")
    public suspend fun containerRegistryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerRegistryName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("axbhrmjcexchfyos")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("fdirqfpebhiojfkn")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetContainerRegistryPlainArgs = GetContainerRegistryPlainArgs(
        containerRegistryName = containerRegistryName ?: throw
            PulumiNullFieldException("containerRegistryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
