@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName The name of the App resource.
 * @property domainName The name of the custom domain resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetCustomDomainPlainArgs(
    public val appName: String,
    public val domainName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetCustomDomainPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetCustomDomainPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .domainName(domainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetCustomDomainPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var domainName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("seddpoemykrspykc")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value The name of the custom domain resource.
     */
    @JvmName("lqkttpvtwrkwdfpt")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gtmwvuyirfknwjiy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("supdvggpeqeuyemx")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetCustomDomainPlainArgs = GetCustomDomainPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
