@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.HTTPGetActionArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.HTTPSchemeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 * @property path Path to access on the HTTP server.
 * @property scheme Scheme to use for connecting to the host. Defaults to HTTP.
 * Possible enum values:
 *  - `"HTTP"` means that the scheme used will be http://
 *  - `"HTTPS"` means that the scheme used will be https://
 * @property type The type of the action to take to perform the health check.
 * Expected value is 'HTTPGetAction'.
 */
public data class HTTPGetActionArgs(
    public val path: Output<String>? = null,
    public val scheme: Output<Either<String, HTTPSchemeType>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.HTTPGetActionArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.HTTPGetActionArgs =
        com.pulumi.azurenative.appplatform.inputs.HTTPGetActionArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .scheme(
                scheme?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HTTPGetActionArgs].
 */
@PulumiTagMarker
public class HTTPGetActionArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var scheme: Output<Either<String, HTTPSchemeType>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Path to access on the HTTP server.
     */
    @JvmName("avtsdyxyvhcescqb")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     * Possible enum values:
     *  - `"HTTP"` means that the scheme used will be http://
     *  - `"HTTPS"` means that the scheme used will be https://
     */
    @JvmName("gjwiouksmnjitatu")
    public suspend fun scheme(`value`: Output<Either<String, HTTPSchemeType>>) {
        this.scheme = value
    }

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'HTTPGetAction'.
     */
    @JvmName("rkhdcnlsallggcgk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Path to access on the HTTP server.
     */
    @JvmName("toanxbgxrowcicep")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     * Possible enum values:
     *  - `"HTTP"` means that the scheme used will be http://
     *  - `"HTTPS"` means that the scheme used will be https://
     */
    @JvmName("alyhhcpmvrwigmuf")
    public suspend fun scheme(`value`: Either<String, HTTPSchemeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     * Possible enum values:
     *  - `"HTTP"` means that the scheme used will be http://
     *  - `"HTTPS"` means that the scheme used will be https://
     */
    @JvmName("nqnctiydbjgamouk")
    public fun scheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HTTPSchemeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value Scheme to use for connecting to the host. Defaults to HTTP.
     * Possible enum values:
     *  - `"HTTP"` means that the scheme used will be http://
     *  - `"HTTPS"` means that the scheme used will be https://
     */
    @JvmName("vnjoxowedupovdkx")
    public fun scheme(`value`: HTTPSchemeType) {
        val toBeMapped = Either.ofRight<String, HTTPSchemeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The type of the action to take to perform the health check.
     * Expected value is 'HTTPGetAction'.
     */
    @JvmName("ikiyjdkbchofdbrp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HTTPGetActionArgs = HTTPGetActionArgs(
        path = path,
        scheme = scheme,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
