@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.IngressSettingsArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.BackendProtocol
import com.pulumi.azurenative.appplatform.kotlin.enums.SessionAffinity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * App ingress settings payload.
 * @property backendProtocol How ingress should communicate with this app backend service.
 * @property clientAuth Client-Certification Authentication.
 * @property readTimeoutInSeconds Ingress read time out in seconds.
 * @property sendTimeoutInSeconds Ingress send time out in seconds.
 * @property sessionAffinity Type of the affinity, set this to Cookie to enable session affinity.
 * @property sessionCookieMaxAge Time in seconds until the cookie expires.
 */
public data class IngressSettingsArgs(
    public val backendProtocol: Output<Either<String, BackendProtocol>>? = null,
    public val clientAuth: Output<IngressSettingsClientAuthArgs>? = null,
    public val readTimeoutInSeconds: Output<Int>? = null,
    public val sendTimeoutInSeconds: Output<Int>? = null,
    public val sessionAffinity: Output<Either<String, SessionAffinity>>? = null,
    public val sessionCookieMaxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.IngressSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.IngressSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.IngressSettingsArgs.builder()
            .backendProtocol(
                backendProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clientAuth(clientAuth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readTimeoutInSeconds(readTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .sendTimeoutInSeconds(sendTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .sessionAffinity(
                sessionAffinity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sessionCookieMaxAge(sessionCookieMaxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngressSettingsArgs].
 */
@PulumiTagMarker
public class IngressSettingsArgsBuilder internal constructor() {
    private var backendProtocol: Output<Either<String, BackendProtocol>>? = null

    private var clientAuth: Output<IngressSettingsClientAuthArgs>? = null

    private var readTimeoutInSeconds: Output<Int>? = null

    private var sendTimeoutInSeconds: Output<Int>? = null

    private var sessionAffinity: Output<Either<String, SessionAffinity>>? = null

    private var sessionCookieMaxAge: Output<Int>? = null

    /**
     * @param value How ingress should communicate with this app backend service.
     */
    @JvmName("tgnxlfilywbplwof")
    public suspend fun backendProtocol(`value`: Output<Either<String, BackendProtocol>>) {
        this.backendProtocol = value
    }

    /**
     * @param value Client-Certification Authentication.
     */
    @JvmName("ghvdpxpurjhcmwem")
    public suspend fun clientAuth(`value`: Output<IngressSettingsClientAuthArgs>) {
        this.clientAuth = value
    }

    /**
     * @param value Ingress read time out in seconds.
     */
    @JvmName("pciyhxxxulohvjqx")
    public suspend fun readTimeoutInSeconds(`value`: Output<Int>) {
        this.readTimeoutInSeconds = value
    }

    /**
     * @param value Ingress send time out in seconds.
     */
    @JvmName("rdfgjqdfkujlsbcy")
    public suspend fun sendTimeoutInSeconds(`value`: Output<Int>) {
        this.sendTimeoutInSeconds = value
    }

    /**
     * @param value Type of the affinity, set this to Cookie to enable session affinity.
     */
    @JvmName("lravemogissibebw")
    public suspend fun sessionAffinity(`value`: Output<Either<String, SessionAffinity>>) {
        this.sessionAffinity = value
    }

    /**
     * @param value Time in seconds until the cookie expires.
     */
    @JvmName("kvmrdyhubesbfyev")
    public suspend fun sessionCookieMaxAge(`value`: Output<Int>) {
        this.sessionCookieMaxAge = value
    }

    /**
     * @param value How ingress should communicate with this app backend service.
     */
    @JvmName("ydekcgmviwtevwuy")
    public suspend fun backendProtocol(`value`: Either<String, BackendProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendProtocol = mapped
    }

    /**
     * @param value How ingress should communicate with this app backend service.
     */
    @JvmName("wairwevwniextkdn")
    public fun backendProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackendProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendProtocol = mapped
    }

    /**
     * @param value How ingress should communicate with this app backend service.
     */
    @JvmName("ocpmssmlfpoqgdgw")
    public fun backendProtocol(`value`: BackendProtocol) {
        val toBeMapped = Either.ofRight<String, BackendProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendProtocol = mapped
    }

    /**
     * @param value Client-Certification Authentication.
     */
    @JvmName("qwvsyrmbbkumkmip")
    public suspend fun clientAuth(`value`: IngressSettingsClientAuthArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuth = mapped
    }

    /**
     * @param argument Client-Certification Authentication.
     */
    @JvmName("jdmdrlxagvvswbhc")
    public suspend fun clientAuth(argument: suspend IngressSettingsClientAuthArgsBuilder.() -> Unit) {
        val toBeMapped = IngressSettingsClientAuthArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientAuth = mapped
    }

    /**
     * @param value Ingress read time out in seconds.
     */
    @JvmName("ciwylktjtbcwnrtf")
    public suspend fun readTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readTimeoutInSeconds = mapped
    }

    /**
     * @param value Ingress send time out in seconds.
     */
    @JvmName("ilwuyehimstqanwe")
    public suspend fun sendTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendTimeoutInSeconds = mapped
    }

    /**
     * @param value Type of the affinity, set this to Cookie to enable session affinity.
     */
    @JvmName("gborbdxkqdiwkxqk")
    public suspend fun sessionAffinity(`value`: Either<String, SessionAffinity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAffinity = mapped
    }

    /**
     * @param value Type of the affinity, set this to Cookie to enable session affinity.
     */
    @JvmName("sjtuxfvwbqfymxpf")
    public fun sessionAffinity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionAffinity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinity = mapped
    }

    /**
     * @param value Type of the affinity, set this to Cookie to enable session affinity.
     */
    @JvmName("rxobsedoubhbhqpb")
    public fun sessionAffinity(`value`: SessionAffinity) {
        val toBeMapped = Either.ofRight<String, SessionAffinity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinity = mapped
    }

    /**
     * @param value Time in seconds until the cookie expires.
     */
    @JvmName("wggvlmcftgkmcrdi")
    public suspend fun sessionCookieMaxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionCookieMaxAge = mapped
    }

    internal fun build(): IngressSettingsArgs = IngressSettingsArgs(
        backendProtocol = backendProtocol,
        clientAuth = clientAuth,
        readTimeoutInSeconds = readTimeoutInSeconds,
        sendTimeoutInSeconds = sendTimeoutInSeconds,
        sessionAffinity = sessionAffinity,
        sessionCookieMaxAge = sessionCookieMaxAge,
    )
}
