@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Job's execution template, containing configuration for an execution
 * @property args Arguments for the Job execution.
 * @property environmentVariables Environment variables of Job execution
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class JobExecutionTemplateArgs(
    public val args: Output<List<String>>? = null,
    public val environmentVariables: Output<List<EnvVarArgs>>? = null,
    public val resourceRequests: Output<JobResourceRequestsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs =
        com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceRequests(
                resourceRequests?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [JobExecutionTemplateArgs].
 */
@PulumiTagMarker
public class JobExecutionTemplateArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var environmentVariables: Output<List<EnvVarArgs>>? = null

    private var resourceRequests: Output<JobResourceRequestsArgs>? = null

    /**
     * @param value Arguments for the Job execution.
     */
    @JvmName("wlsejfqrtiivpvsc")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("janispwkqiisfoka")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Arguments for the Job execution.
     */
    @JvmName("qtkabocbrwpxxawc")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Environment variables of Job execution
     */
    @JvmName("plfaignxihlqkcom")
    public suspend fun environmentVariables(`value`: Output<List<EnvVarArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("omdwhgepejbedtfm")
    public suspend fun environmentVariables(vararg values: Output<EnvVarArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values Environment variables of Job execution
     */
    @JvmName("qbeotpgkgertxyme")
    public suspend fun environmentVariables(values: List<Output<EnvVarArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory.
     */
    @JvmName("sjnowoqkfowefggc")
    public suspend fun resourceRequests(`value`: Output<JobResourceRequestsArgs>) {
        this.resourceRequests = value
    }

    /**
     * @param value Arguments for the Job execution.
     */
    @JvmName("jgolkfxooyaglbxn")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Arguments for the Job execution.
     */
    @JvmName("movlbgwuoacohjsf")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Environment variables of Job execution
     */
    @JvmName("qxwhxkidsdxptmcl")
    public suspend fun environmentVariables(`value`: List<EnvVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument Environment variables of Job execution
     */
    @JvmName("scpkdccppnpewfbl")
    public suspend fun environmentVariables(argument: List<suspend EnvVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EnvVarArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument Environment variables of Job execution
     */
    @JvmName("cqahxrsisjohwatx")
    public suspend fun environmentVariables(vararg argument: suspend EnvVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EnvVarArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument Environment variables of Job execution
     */
    @JvmName("kxulhpvvsauorjpf")
    public suspend fun environmentVariables(argument: suspend EnvVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvVarArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables of Job execution
     */
    @JvmName("hkoevfcnqgbtinxl")
    public suspend fun environmentVariables(vararg values: EnvVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory.
     */
    @JvmName("xjpxuhbacaapdqlo")
    public suspend fun resourceRequests(`value`: JobResourceRequestsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequests = mapped
    }

    /**
     * @param argument The requested resource quantity for required CPU and Memory.
     */
    @JvmName("imyngmfxricrvoic")
    public suspend fun resourceRequests(argument: suspend JobResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = JobResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceRequests = mapped
    }

    internal fun build(): JobExecutionTemplateArgs = JobExecutionTemplateArgs(
        args = args,
        environmentVariables = environmentVariables,
        resourceRequests = resourceRequests,
    )
}
