@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Job resource properties payload
 * @property managedComponentReferences Referenced managed components collection
 * @property source Uploaded source information of the Job.
 * @property template The template which is applied for all executions of the Job.
 * @property triggerConfig The Job trigger related configuration.
 */
public data class JobResourcePropertiesArgs(
    public val managedComponentReferences: Output<List<ManagedComponentReferenceArgs>>? = null,
    public val source: Output<Any>? = null,
    public val template: Output<JobExecutionTemplateArgs>? = null,
    public val triggerConfig: Output<ManualJobTriggerConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs.builder()
            .managedComponentReferences(
                managedComponentReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .source(source?.applyValue({ args0 -> args0 }))
            .template(template?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggerConfig(triggerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobResourcePropertiesArgs].
 */
@PulumiTagMarker
public class JobResourcePropertiesArgsBuilder internal constructor() {
    private var managedComponentReferences: Output<List<ManagedComponentReferenceArgs>>? = null

    private var source: Output<Any>? = null

    private var template: Output<JobExecutionTemplateArgs>? = null

    private var triggerConfig: Output<ManualJobTriggerConfigArgs>? = null

    /**
     * @param value Referenced managed components collection
     */
    @JvmName("txckrfwocugnevjo")
    public suspend fun managedComponentReferences(`value`: Output<List<ManagedComponentReferenceArgs>>) {
        this.managedComponentReferences = value
    }

    @JvmName("yepacxwaxteahfkg")
    public suspend fun managedComponentReferences(vararg values: Output<ManagedComponentReferenceArgs>) {
        this.managedComponentReferences = Output.all(values.asList())
    }

    /**
     * @param values Referenced managed components collection
     */
    @JvmName("jjnsimwmkxscviin")
    public suspend fun managedComponentReferences(values: List<Output<ManagedComponentReferenceArgs>>) {
        this.managedComponentReferences = Output.all(values)
    }

    /**
     * @param value Uploaded source information of the Job.
     */
    @JvmName("jraymkkbefwfeuyf")
    public suspend fun source(`value`: Output<Any>) {
        this.source = value
    }

    /**
     * @param value The template which is applied for all executions of the Job.
     */
    @JvmName("snbwsjlkcstkjilh")
    public suspend fun template(`value`: Output<JobExecutionTemplateArgs>) {
        this.template = value
    }

    /**
     * @param value The Job trigger related configuration.
     */
    @JvmName("hkbaxmouytfeyfpa")
    public suspend fun triggerConfig(`value`: Output<ManualJobTriggerConfigArgs>) {
        this.triggerConfig = value
    }

    /**
     * @param value Referenced managed components collection
     */
    @JvmName("clhcddokswjpfmjt")
    public suspend fun managedComponentReferences(`value`: List<ManagedComponentReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedComponentReferences = mapped
    }

    /**
     * @param argument Referenced managed components collection
     */
    @JvmName("injkporrexumlgsm")
    public suspend fun managedComponentReferences(argument: List<suspend ManagedComponentReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedComponentReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedComponentReferences = mapped
    }

    /**
     * @param argument Referenced managed components collection
     */
    @JvmName("ilrifepiexxgdohu")
    public suspend fun managedComponentReferences(vararg argument: suspend ManagedComponentReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedComponentReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedComponentReferences = mapped
    }

    /**
     * @param argument Referenced managed components collection
     */
    @JvmName("xjxnmacjqxqvxlps")
    public suspend fun managedComponentReferences(argument: suspend ManagedComponentReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedComponentReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.managedComponentReferences = mapped
    }

    /**
     * @param values Referenced managed components collection
     */
    @JvmName("cdvrndvhvxvhgjmf")
    public suspend fun managedComponentReferences(vararg values: ManagedComponentReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedComponentReferences = mapped
    }

    /**
     * @param value Uploaded source information of the Job.
     */
    @JvmName("aprlxihpvtbmqrnf")
    public suspend fun source(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The template which is applied for all executions of the Job.
     */
    @JvmName("rdhblapbeokkvtwv")
    public suspend fun template(`value`: JobExecutionTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param argument The template which is applied for all executions of the Job.
     */
    @JvmName("xpehfthdmajynedo")
    public suspend fun template(argument: suspend JobExecutionTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = JobExecutionTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.template = mapped
    }

    /**
     * @param value The Job trigger related configuration.
     */
    @JvmName("jixivohrjywfdjvo")
    public suspend fun triggerConfig(`value`: ManualJobTriggerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerConfig = mapped
    }

    /**
     * @param argument The Job trigger related configuration.
     */
    @JvmName("gjulsxkfjrqiunqi")
    public suspend fun triggerConfig(argument: suspend ManualJobTriggerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ManualJobTriggerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.triggerConfig = mapped
    }

    internal fun build(): JobResourcePropertiesArgs = JobResourcePropertiesArgs(
        managedComponentReferences = managedComponentReferences,
        source = source,
        template = template,
        triggerConfig = triggerConfig,
    )
}
