@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.JobResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Job resource request payload
 * @property cpu CPU allocated to each job execution instance.
 * @property memory Memory allocated to each job execution instance.
 */
public data class JobResourceRequestsArgs(
    public val cpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.JobResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.JobResourceRequestsArgs =
        com.pulumi.azurenative.appplatform.inputs.JobResourceRequestsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobResourceRequestsArgs].
 */
@PulumiTagMarker
public class JobResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value CPU allocated to each job execution instance.
     */
    @JvmName("dlkkhucchuwkqxph")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Memory allocated to each job execution instance.
     */
    @JvmName("grmntcmlrrtwnxqc")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value CPU allocated to each job execution instance.
     */
    @JvmName("hpudvdangjopbips")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Memory allocated to each job execution instance.
     */
    @JvmName("vijfhcohiwdaqsct")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): JobResourceRequestsArgs = JobResourceRequestsArgs(
        cpu = cpu,
        memory = memory,
    )
}
