@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ListJobExecutionEnvSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobExecutionName The name of the Job execution.
 * @property jobName The name of the Job resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class ListJobExecutionEnvSecretsPlainArgs(
    public val jobExecutionName: String,
    public val jobName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ListJobExecutionEnvSecretsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ListJobExecutionEnvSecretsPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.ListJobExecutionEnvSecretsPlainArgs.builder()
            .jobExecutionName(jobExecutionName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListJobExecutionEnvSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListJobExecutionEnvSecretsPlainArgsBuilder internal constructor() {
    private var jobExecutionName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the Job execution.
     */
    @JvmName("dfsrxlbuurxbgjxp")
    public suspend fun jobExecutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobExecutionName = mapped
    }

    /**
     * @param value The name of the Job resource.
     */
    @JvmName("bivhuufpotrhlxjp")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("egmqldlglbavwwvu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("gisolupkbisrrevd")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListJobExecutionEnvSecretsPlainArgs = ListJobExecutionEnvSecretsPlainArgs(
        jobExecutionName = jobExecutionName ?: throw PulumiNullFieldException("jobExecutionName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
