@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.LoadedCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Loaded certificate payload
 * @property loadTrustStore Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
 * @property resourceId Resource Id of loaded certificate
 */
public data class LoadedCertificateArgs(
    public val loadTrustStore: Output<Boolean>? = null,
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.LoadedCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.LoadedCertificateArgs =
        com.pulumi.azurenative.appplatform.inputs.LoadedCertificateArgs.builder()
            .loadTrustStore(loadTrustStore?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadedCertificateArgs].
 */
@PulumiTagMarker
public class LoadedCertificateArgsBuilder internal constructor() {
    private var loadTrustStore: Output<Boolean>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
     */
    @JvmName("qqplokfyfphaapxr")
    public suspend fun loadTrustStore(`value`: Output<Boolean>) {
        this.loadTrustStore = value
    }

    /**
     * @param value Resource Id of loaded certificate
     */
    @JvmName("qklpnaxxwjdujeey")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
     */
    @JvmName("usggwdylypqksncl")
    public suspend fun loadTrustStore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadTrustStore = mapped
    }

    /**
     * @param value Resource Id of loaded certificate
     */
    @JvmName("afvjcsqrlxigbgha")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): LoadedCertificateArgs = LoadedCertificateArgs(
        loadTrustStore = loadTrustStore,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
