@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ManagedComponentReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to the managed component like Config Server.
 * @property resourceId Resource Id of the managed component
 */
public data class ManagedComponentReferenceArgs(
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ManagedComponentReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ManagedComponentReferenceArgs =
        com.pulumi.azurenative.appplatform.inputs.ManagedComponentReferenceArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedComponentReferenceArgs].
 */
@PulumiTagMarker
public class ManagedComponentReferenceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value Resource Id of the managed component
     */
    @JvmName("nfqjtxylxrvtjhho")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource Id of the managed component
     */
    @JvmName("vgkvovfatwucsgnd")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ManagedComponentReferenceArgs = ManagedComponentReferenceArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
