@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ManagedIdentityPropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.ManagedIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed identity properties retrieved from ARM request headers.
 * @property principalId Principal Id of system-assigned managed identity.
 * @property tenantId Tenant Id of system-assigned managed identity.
 * @property type Type of the managed identity
 * @property userAssignedIdentities Properties of user-assigned managed identities
 */
public data class ManagedIdentityPropertiesArgs(
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<Either<String, ManagedIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ManagedIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ManagedIdentityPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ManagedIdentityPropertiesArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedIdentityPropertiesArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<Either<String, ManagedIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Principal Id of system-assigned managed identity.
     */
    @JvmName("smqqtftrlnaewcdl")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Tenant Id of system-assigned managed identity.
     */
    @JvmName("nbfywycsgdxuyqeh")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Type of the managed identity
     */
    @JvmName("fkrskcyulvrxknkh")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityType>>) {
        this.type = value
    }

    /**
     * @param value Properties of user-assigned managed identities
     */
    @JvmName("xuxfhwcyicmnkycr")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("veqhjoqxqvpsbnaj")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Properties of user-assigned managed identities
     */
    @JvmName("vjfcqlgefqoceojk")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Principal Id of system-assigned managed identity.
     */
    @JvmName("kncikkxwrpwxhpok")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Tenant Id of system-assigned managed identity.
     */
    @JvmName("yxwvfmfvfsmajmns")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Type of the managed identity
     */
    @JvmName("ptmgwwquphdgihpc")
    public suspend fun type(`value`: Either<String, ManagedIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity
     */
    @JvmName("hnsvfirgbvcqtjqr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the managed identity
     */
    @JvmName("vuvfgolqlsqksupy")
    public fun type(`value`: ManagedIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Properties of user-assigned managed identities
     */
    @JvmName("wwdlbxdbrftrrtrb")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Properties of user-assigned managed identities
     */
    @JvmName("clrjiuambnvghgte")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ManagedIdentityPropertiesArgs = ManagedIdentityPropertiesArgs(
        principalId = principalId,
        tenantId = tenantId,
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
