@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for manual triggered job
 * @property parallelism Number of parallel replicas of a job execution can run.
 * @property retryLimit Maximum number of retries before failing the job.
 * @property timeoutInSeconds Maximum number of seconds an execution is allowed to run.
 * @property triggerType Type of job trigger
 * Expected value is 'Manual'.
 */
public data class ManualJobTriggerConfigArgs(
    public val parallelism: Output<Int>? = null,
    public val retryLimit: Output<Int>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
    public val triggerType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs =
        com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs.builder()
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .retryLimit(retryLimit?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .triggerType(triggerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManualJobTriggerConfigArgs].
 */
@PulumiTagMarker
public class ManualJobTriggerConfigArgsBuilder internal constructor() {
    private var parallelism: Output<Int>? = null

    private var retryLimit: Output<Int>? = null

    private var timeoutInSeconds: Output<Int>? = null

    private var triggerType: Output<String>? = null

    /**
     * @param value Number of parallel replicas of a job execution can run.
     */
    @JvmName("xbopcfnybhyuywuf")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Maximum number of retries before failing the job.
     */
    @JvmName("chakamholsbhyyly")
    public suspend fun retryLimit(`value`: Output<Int>) {
        this.retryLimit = value
    }

    /**
     * @param value Maximum number of seconds an execution is allowed to run.
     */
    @JvmName("fqejgigbggnweots")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Type of job trigger
     * Expected value is 'Manual'.
     */
    @JvmName("caapvnhqpghflggj")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value Number of parallel replicas of a job execution can run.
     */
    @JvmName("ugptvhhysckbrlew")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Maximum number of retries before failing the job.
     */
    @JvmName("rhxommjmmgmuuaab")
    public suspend fun retryLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryLimit = mapped
    }

    /**
     * @param value Maximum number of seconds an execution is allowed to run.
     */
    @JvmName("bpuewnbexitawghx")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value Type of job trigger
     * Expected value is 'Manual'.
     */
    @JvmName("qptpwhcxsixqefvr")
    public suspend fun triggerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): ManualJobTriggerConfigArgs = ManualJobTriggerConfigArgs(
        parallelism = parallelism,
        retryLimit = retryLimit,
        timeoutInSeconds = timeoutInSeconds,
        triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
    )
}
