@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.MarketplaceResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Purchasing 3rd Party product for one Azure Spring Apps instance
 * @property plan The plan id of the 3rd Party Artifact that is being procured.
 * @property product The 3rd Party artifact that is being procured.
 * @property publisher The publisher id of the 3rd Party Artifact that is being bought.
 */
public data class MarketplaceResourceArgs(
    public val plan: Output<String>? = null,
    public val product: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.MarketplaceResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.MarketplaceResourceArgs =
        com.pulumi.azurenative.appplatform.inputs.MarketplaceResourceArgs.builder()
            .plan(plan?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarketplaceResourceArgs].
 */
@PulumiTagMarker
public class MarketplaceResourceArgsBuilder internal constructor() {
    private var plan: Output<String>? = null

    private var product: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The plan id of the 3rd Party Artifact that is being procured.
     */
    @JvmName("arpmxuboyxxkgwoh")
    public suspend fun plan(`value`: Output<String>) {
        this.plan = value
    }

    /**
     * @param value The 3rd Party artifact that is being procured.
     */
    @JvmName("pbcttldrflqcogre")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The publisher id of the 3rd Party Artifact that is being bought.
     */
    @JvmName("douxbkogjiyoweys")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan id of the 3rd Party Artifact that is being procured.
     */
    @JvmName("wokfkysovbblphsk")
    public suspend fun plan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param value The 3rd Party artifact that is being procured.
     */
    @JvmName("yakpgjjmrswjbqsf")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The publisher id of the 3rd Party Artifact that is being bought.
     */
    @JvmName("eihiohlmeucxcgge")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): MarketplaceResourceArgs = MarketplaceResourceArgs(
        plan = plan,
        product = product,
        publisher = publisher,
    )
}
