@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.NetCoreZipUploadedUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploaded Jar binary for a deployment
 * @property netCoreMainEntryPath The path to the .NET executable relative to zip root
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the .Net file
 * @property type Type of the source uploaded
 * Expected value is 'NetCoreZip'.
 * @property version Version of the source
 */
public data class NetCoreZipUploadedUserSourceInfoArgs(
    public val netCoreMainEntryPath: Output<String>? = null,
    public val relativePath: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.NetCoreZipUploadedUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.NetCoreZipUploadedUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.NetCoreZipUploadedUserSourceInfoArgs.builder()
            .netCoreMainEntryPath(netCoreMainEntryPath?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetCoreZipUploadedUserSourceInfoArgs].
 */
@PulumiTagMarker
public class NetCoreZipUploadedUserSourceInfoArgsBuilder internal constructor() {
    private var netCoreMainEntryPath: Output<String>? = null

    private var relativePath: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The path to the .NET executable relative to zip root
     */
    @JvmName("pyyrfwibxjwlxfkm")
    public suspend fun netCoreMainEntryPath(`value`: Output<String>) {
        this.netCoreMainEntryPath = value
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("wfxesvvmaxbtoqai")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Runtime version of the .Net file
     */
    @JvmName("nrjuhrdlsicctslf")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'NetCoreZip'.
     */
    @JvmName("pllaqnvmiutkwtnk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("kutrlfyeaivwbvvs")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The path to the .NET executable relative to zip root
     */
    @JvmName("ymsrfchvtvcawjsg")
    public suspend fun netCoreMainEntryPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreMainEntryPath = mapped
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("lojuevjlnbennawm")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value Runtime version of the .Net file
     */
    @JvmName("blthqjrfrjmwupev")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'NetCoreZip'.
     */
    @JvmName("yydacsynoureggms")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("anihhtsoqktokiop")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): NetCoreZipUploadedUserSourceInfoArgs = NetCoreZipUploadedUserSourceInfoArgs(
        netCoreMainEntryPath = netCoreMainEntryPath,
        relativePath = relativePath,
        runtimeVersion = runtimeVersion,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
