@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.PersistentDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Persistent disk payload
 * @property mountPath Mount path of the persistent disk
 * @property sizeInGB Size of the persistent disk in GB
 */
public data class PersistentDiskArgs(
    public val mountPath: Output<String>? = null,
    public val sizeInGB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.PersistentDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.PersistentDiskArgs =
        com.pulumi.azurenative.appplatform.inputs.PersistentDiskArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .sizeInGB(sizeInGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PersistentDiskArgs].
 */
@PulumiTagMarker
public class PersistentDiskArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var sizeInGB: Output<Int>? = null

    /**
     * @param value Mount path of the persistent disk
     */
    @JvmName("iufcaqvllsudiqtt")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Size of the persistent disk in GB
     */
    @JvmName("tsaleabittrkcmyr")
    public suspend fun sizeInGB(`value`: Output<Int>) {
        this.sizeInGB = value
    }

    /**
     * @param value Mount path of the persistent disk
     */
    @JvmName("xxhrychftytxhbnj")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Size of the persistent disk in GB
     */
    @JvmName("athxxtplxxxuteca")
    public suspend fun sizeInGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInGB = mapped
    }

    internal fun build(): PersistentDiskArgs = PersistentDiskArgs(
        mountPath = mountPath,
        sizeInGB = sizeInGB,
    )
}
