@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.UploadedUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Source with uploaded location
 * @property relativePath Relative path of the storage which stores the source
 * @property type Type of the source uploaded
 * Expected value is 'UploadedUserSourceInfo'.
 * @property version Version of the source
 */
public data class UploadedUserSourceInfoArgs(
    public val relativePath: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.UploadedUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.UploadedUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.UploadedUserSourceInfoArgs.builder()
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UploadedUserSourceInfoArgs].
 */
@PulumiTagMarker
public class UploadedUserSourceInfoArgsBuilder internal constructor() {
    private var relativePath: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("sdvpvgnndgjgwrdn")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'UploadedUserSourceInfo'.
     */
    @JvmName("kplnmoqpebamfgeb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("wrnsrvicxpqltvra")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("geawfpjpeyyinlvo")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'UploadedUserSourceInfo'.
     */
    @JvmName("unhwlmvodwfsqbpf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("mitlydubnuocpagf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): UploadedUserSourceInfoArgs = UploadedUserSourceInfoArgs(
        relativePath = relativePath,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
