@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.WarUploadedUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploaded War binary for a deployment
 * @property jvmOptions JVM parameter
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the war file
 * @property serverVersion Server version, currently only Apache Tomcat is supported
 * @property type Type of the source uploaded
 * Expected value is 'War'.
 * @property version Version of the source
 */
public data class WarUploadedUserSourceInfoArgs(
    public val jvmOptions: Output<String>? = null,
    public val relativePath: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val serverVersion: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.WarUploadedUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.WarUploadedUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.WarUploadedUserSourceInfoArgs.builder()
            .jvmOptions(jvmOptions?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .serverVersion(serverVersion?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WarUploadedUserSourceInfoArgs].
 */
@PulumiTagMarker
public class WarUploadedUserSourceInfoArgsBuilder internal constructor() {
    private var jvmOptions: Output<String>? = null

    private var relativePath: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var serverVersion: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value JVM parameter
     */
    @JvmName("qkrncerjlhgoodxd")
    public suspend fun jvmOptions(`value`: Output<String>) {
        this.jvmOptions = value
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("nlexpnklbaomfkko")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Runtime version of the war file
     */
    @JvmName("qxteudknjfekyhej")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Server version, currently only Apache Tomcat is supported
     */
    @JvmName("cjrvqecgehvjbtcu")
    public suspend fun serverVersion(`value`: Output<String>) {
        this.serverVersion = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'War'.
     */
    @JvmName("qdvbshtmsonfnuhr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("huoyobjxfyryceeq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value JVM parameter
     */
    @JvmName("jlvclkrisjuydthg")
    public suspend fun jvmOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmOptions = mapped
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("hhsrshdnolvkcomk")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value Runtime version of the war file
     */
    @JvmName("iktcfehgutlcruiv")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Server version, currently only Apache Tomcat is supported
     */
    @JvmName("tmqdqktxnlubyhop")
    public suspend fun serverVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverVersion = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'War'.
     */
    @JvmName("yqnvcillopdosalh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("dgxxftpfemeywbsi")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): WarUploadedUserSourceInfoArgs = WarUploadedUserSourceInfoArgs(
        jvmOptions = jvmOptions,
        relativePath = relativePath,
        runtimeVersion = runtimeVersion,
        serverVersion = serverVersion,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
