@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Auth setting for basic auth.
 * @property authType The type of the auth setting.
 * Expected value is 'BasicAuth'.
 * @property caCertResourceId Resource Id of CA certificate for https URL of Git repository.
 * @property username Username of git repository basic auth.
 */
public data class AcceleratorBasicAuthSettingResponse(
    public val authType: String,
    public val caCertResourceId: String? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AcceleratorBasicAuthSettingResponse): AcceleratorBasicAuthSettingResponse = AcceleratorBasicAuthSettingResponse(
            authType = javaType.authType(),
            caCertResourceId = javaType.caCertResourceId().map({ args0 -> args0 }).orElse(null),
            username = javaType.username(),
        )
    }
}
