@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authSetting Properties of the auth setting payload.
 * @property branch Git repository branch to be used.
 * @property commit Git repository commit to be used.
 * @property gitTag Git repository tag to be used.
 * @property intervalInSeconds Interval for checking for updates to Git or image repository.
 * @property url Git repository URL for the accelerator.
 */
public data class AcceleratorGitRepositoryResponse(
    public val authSetting: Any,
    public val branch: String? = null,
    public val commit: String? = null,
    public val gitTag: String? = null,
    public val intervalInSeconds: Int? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AcceleratorGitRepositoryResponse): AcceleratorGitRepositoryResponse = AcceleratorGitRepositoryResponse(
            authSetting = javaType.authSetting(),
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            commit = javaType.commit().map({ args0 -> args0 }).orElse(null),
            gitTag = javaType.gitTag().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            url = javaType.url(),
        )
    }
}
