@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Auth setting for public url.
 * @property authType The type of the auth setting.
 * Expected value is 'Public'.
 * @property caCertResourceId Resource Id of CA certificate for https URL of Git repository.
 */
public data class AcceleratorPublicSettingResponse(
    public val authType: String,
    public val caCertResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AcceleratorPublicSettingResponse): AcceleratorPublicSettingResponse = AcceleratorPublicSettingResponse(
            authType = javaType.authType(),
            caCertResourceId = javaType.caCertResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
