@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource requests of the API portal
 * @property cpu Cpu allocated to each API portal instance
 * @property memory Memory allocated to each API portal instance
 */
public data class ApiPortalResourceRequestsResponse(
    public val cpu: String,
    public val memory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApiPortalResourceRequestsResponse): ApiPortalResourceRequestsResponse = ApiPortalResourceRequestsResponse(
            cpu = javaType.cpu(),
            memory = javaType.memory(),
        )
    }
}
