@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Additional App settings in vnet injection instance
 * @property publicEndpoint Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
 * @property publicEndpointUrl URL of the App in vnet injection instance which could be accessed from internet
 */
public data class AppVNetAddonsResponse(
    public val publicEndpoint: Boolean? = null,
    public val publicEndpointUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AppVNetAddonsResponse): AppVNetAddonsResponse = AppVNetAddonsResponse(
            publicEndpoint = javaType.publicEndpoint().map({ args0 -> args0 }).orElse(null),
            publicEndpointUrl = javaType.publicEndpointUrl(),
        )
    }
}
