@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instances
 * @property name
 * @property resourceRequests
 */
public data class ApplicationAcceleratorComponentResponse(
    public val instances: List<ApplicationAcceleratorInstanceResponse>,
    public val name: String,
    public val resourceRequests: ApplicationAcceleratorResourceRequestsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationAcceleratorComponentResponse): ApplicationAcceleratorComponentResponse = ApplicationAcceleratorComponentResponse(
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationAcceleratorInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            resourceRequests = javaType.resourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationAcceleratorResourceRequestsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
