@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application accelerator properties payload
 * @property components Collection of components belong to application accelerator.
 * @property provisioningState State of the application accelerator.
 */
public data class ApplicationAcceleratorPropertiesResponse(
    public val components: List<ApplicationAcceleratorComponentResponse>,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationAcceleratorPropertiesResponse): ApplicationAcceleratorPropertiesResponse = ApplicationAcceleratorPropertiesResponse(
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationAcceleratorComponentResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
