@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application Live View properties payload
 * @property instances Collection of instances belong to Application Live View.
 * @property name Name of the component.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 */
public data class ApplicationLiveViewComponentResponse(
    public val instances: List<ApplicationLiveViewInstanceResponse>,
    public val name: Any,
    public val resourceRequests: ApplicationLiveViewResourceRequestsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationLiveViewComponentResponse): ApplicationLiveViewComponentResponse = ApplicationLiveViewComponentResponse(
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationLiveViewInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationLiveViewResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
