@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection of instances belong to the Application Live View
 * @property name Name of the Application Live View instance.
 * @property status Status of the Application Live View instance. It can be Pending, Running, Succeeded, Failed, Unknown.
 */
public data class ApplicationLiveViewInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationLiveViewInstanceResponse): ApplicationLiveViewInstanceResponse = ApplicationLiveViewInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
