@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Application Live View properties payload
 * @property components Component details of Application Live View
 * @property provisioningState State of the Application Live View.
 */
public data class ApplicationLiveViewPropertiesResponse(
    public val components: List<ApplicationLiveViewComponentResponse>,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationLiveViewPropertiesResponse): ApplicationLiveViewPropertiesResponse = ApplicationLiveViewPropertiesResponse(
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationLiveViewComponentResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
