@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the Azure File volume. Azure File shares are mounted as volumes.
 * @property enableSubPath If set to true, it will create and mount a dedicated directory for every individual app instance.
 * @property mountOptions These are the mount options for a persistent disk.
 * @property mountPath The mount path of the persistent disk.
 * @property readOnly Indicates whether the persistent disk is a readOnly one.
 * @property shareName The share name of the Azure File share.
 * @property type The type of the underlying resource to mount as a persistent disk.
 * Expected value is 'AzureFileVolume'.
 */
public data class AzureFileVolumeResponse(
    public val enableSubPath: Boolean? = null,
    public val mountOptions: List<String>? = null,
    public val mountPath: String,
    public val readOnly: Boolean? = null,
    public val shareName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AzureFileVolumeResponse): AzureFileVolumeResponse = AzureFileVolumeResponse(
            enableSubPath = javaType.enableSubPath().map({ args0 -> args0 }).orElse(null),
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }),
            mountPath = javaType.mountPath(),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            shareName = javaType.shareName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
