@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Binding resource properties payload
 * @property bindingParameters Binding parameters of the Binding resource
 * @property createdAt Creation time of the Binding resource
 * @property generatedProperties The generated Spring Boot property file for this binding. The secret will be deducted.
 * @property key The key of the bound resource
 * @property resourceId The Azure resource id of the bound resource
 * @property resourceName The name of the bound resource
 * @property resourceType The standard Azure resource type of the bound resource
 * @property updatedAt Update time of the Binding resource
 */
public data class BindingResourcePropertiesResponse(
    public val bindingParameters: Map<String, String>? = null,
    public val createdAt: String,
    public val generatedProperties: String,
    public val key: String? = null,
    public val resourceId: String? = null,
    public val resourceName: String,
    public val resourceType: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BindingResourcePropertiesResponse): BindingResourcePropertiesResponse = BindingResourcePropertiesResponse(
            bindingParameters = javaType.bindingParameters().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            createdAt = javaType.createdAt(),
            generatedProperties = javaType.generatedProperties(),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName(),
            resourceType = javaType.resourceType(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
