@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Build service agent pool properties
 * @property poolSize build service agent pool size properties
 * @property provisioningState Provisioning state of the build service agent pool
 */
public data class BuildServiceAgentPoolPropertiesResponse(
    public val poolSize: BuildServiceAgentPoolSizePropertiesResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildServiceAgentPoolPropertiesResponse): BuildServiceAgentPoolPropertiesResponse = BuildServiceAgentPoolPropertiesResponse(
            poolSize = javaType.poolSize().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.BuildServiceAgentPoolSizePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
