@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * KPack Builder properties payload
 * @property buildpackGroups Builder buildpack groups.
 * @property provisioningState Builder provision status.
 * @property stack Builder cluster stack property.
 */
public data class BuilderPropertiesResponse(
    public val buildpackGroups: List<BuildpacksGroupPropertiesResponse>? = null,
    public val provisioningState: String,
    public val stack: StackPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuilderPropertiesResponse): BuilderPropertiesResponse = BuilderPropertiesResponse(
            buildpackGroups = javaType.buildpackGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.BuildpacksGroupPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            stack = javaType.stack().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.StackPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
