@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Buildpack group properties of the Builder
 * @property buildpacks Buildpacks in the buildpack group
 * @property name Buildpack group name
 */
public data class BuildpacksGroupPropertiesResponse(
    public val buildpacks: List<BuildpackPropertiesResponse>? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildpacksGroupPropertiesResponse): BuildpacksGroupPropertiesResponse = BuildpacksGroupPropertiesResponse(
            buildpacks = javaType.buildpacks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.BuildpackPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
