@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Service properties payload
 * @property fqdn Fully qualified dns name of the service instance
 * @property infraResourceGroup The name of the resource group that contains the infrastructure resources
 * @property managedEnvironmentId The resource Id of the Managed Environment that the Spring Apps instance builds on
 * @property marketplaceResource Purchasing 3rd party product of the Service resource.
 * @property networkProfile Network profile of the Service
 * @property powerState Power state of the Service
 * @property provisioningState Provisioning state of the Service
 * @property serviceId ServiceInstanceEntity Id which uniquely identifies a created resource
 * @property version Version of the Service
 * @property vnetAddons Additional Service settings in vnet injection instance
 * @property zoneRedundant
 */
public data class ClusterResourcePropertiesResponse(
    public val fqdn: String,
    public val infraResourceGroup: String? = null,
    public val managedEnvironmentId: String? = null,
    public val marketplaceResource: MarketplaceResourceResponse? = null,
    public val networkProfile: NetworkProfileResponse? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val serviceId: String,
    public val version: Int,
    public val vnetAddons: ServiceVNetAddonsResponse? = null,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ClusterResourcePropertiesResponse): ClusterResourcePropertiesResponse = ClusterResourcePropertiesResponse(
            fqdn = javaType.fqdn(),
            infraResourceGroup = javaType.infraResourceGroup().map({ args0 -> args0 }).orElse(null),
            managedEnvironmentId = javaType.managedEnvironmentId().map({ args0 -> args0 }).orElse(null),
            marketplaceResource = javaType.marketplaceResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.MarketplaceResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            serviceId = javaType.serviceId(),
            version = javaType.version(),
            vnetAddons = javaType.vnetAddons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ServiceVNetAddonsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
