@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Config server git properties payload
 * @property configServer Settings of config server.
 * @property enabledState Enabled state of the config server. This is only used in Consumption tier.
 * @property error Error when apply config server settings.
 * @property provisioningState State of the config server.
 */
public data class ConfigServerPropertiesResponse(
    public val configServer: ConfigServerSettingsResponse? = null,
    public val enabledState: String? = null,
    public val error: ErrorResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ConfigServerPropertiesResponse): ConfigServerPropertiesResponse = ConfigServerPropertiesResponse(
            configServer = javaType.configServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigServerSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
