@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Resource request payload of Application Configuration Service
 * @property cpu Cpu allocated to each Application Configuration Service instance
 * @property instanceCount Instance count of the Application Configuration Service
 * @property memory Memory allocated to each Application Configuration Service instance
 */
public data class ConfigurationServiceResourceRequestsResponse(
    public val cpu: String,
    public val instanceCount: Int,
    public val memory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ConfigurationServiceResourceRequestsResponse): ConfigurationServiceResourceRequestsResponse = ConfigurationServiceResourceRequestsResponse(
            cpu = javaType.cpu(),
            instanceCount = javaType.instanceCount(),
            memory = javaType.memory(),
        )
    }
}
