@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Container liveness and readiness probe settings
 * @property disableProbe Indicates whether disable the liveness and readiness probe
 */
public data class ContainerProbeSettingsResponse(
    public val disableProbe: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ContainerProbeSettingsResponse): ContainerProbeSettingsResponse = ContainerProbeSettingsResponse(
            disableProbe = javaType.disableProbe().map({ args0 -> args0 }).orElse(null),
        )
    }
}
