@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The basic authentication properties for the container registry resource.
 * @property server The login server of the Container Registry.
 * @property type The credential type of the container registry credentials.
 * Expected value is 'BasicAuth'.
 * @property username The username of the Container Registry.
 */
public data class ContainerRegistryBasicCredentialsResponse(
    public val server: String,
    public val type: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ContainerRegistryBasicCredentialsResponse): ContainerRegistryBasicCredentialsResponse = ContainerRegistryBasicCredentialsResponse(
            server = javaType.server(),
            type = javaType.type(),
            username = javaType.username(),
        )
    }
}
